<?php

///////////////////////////////////////////////////////////////////////////////
/* file       : XMP_status.php
 programmer : [GDC]Analhusten <nonono@gmx.de> 
				code based on excellent work of Michiel 'El Muerte' Hendriks <elmuerte@drunksnipers.com>
 purpose    : U2::XMP Server quering
 version    : 1.0.0
 usage      : System Requirements:
                Your webserver needs to run at least PHP version 4.1.0
                Besides that there are no requirements

              This script is pretty easy to use, just include it in your own
              script and make sure to following things are set:
              global variables:
              $HTTP_VARS["ip"] = hostname/ip of the game server
              $HTTP_VARS["gp"] = the game port of the host (7777 if omitted)
 				$HTTP_VARS["monochrome"] = true/false for displaying the playerinfo in color or monochrome
              Then call the function: retreiveStatus($display,$error)
                $display is a function of the form:
                  function somename($serverinfo)
                  where $serverinfo is an array with server info
                  
					Example: echo retreiveStatus('display_Info');			

                   The data containing $info is:
                    
					$info["servername"]
					$info["adminname"]
					$info["adminemail"]
					$info["mutator"]
					$info["gameport"]
					$info["serverversion"]
					$info["servermode"]
					$info["autobalance"]
					$info["gamestats"]
					$info["mapname"]
					$info["numplayers"] 
					$info["maxplayers"] 
					$info["teamdamage"]
					$info["respawntime"]
					$info["prematchwait"]
	
				   Information about players can be acessed like this:

					 info["player_n"] -- 	Name of Player where 0 < n < $info["numplayers"]
											Warning: result is in binary format. Use colorize_it() 
											for tagged color information or uncolorize_it for monochrome view.

					
					$info["ping_n"] 	--	Ping of player n
					$info["score_n"] 	--	Score of player n
					$info["props_n"] 	--	Number of properties of player n (always 3)
					$info["ping_n"] 	--	Ping of player n

					$info["player n info_key m"] - Player n property m Key (e.g. "Artifact". Order is "Team", "Class", "Artifact")
					$info["player n info_val m"] - Player n property m Value (e.g. "true")		
*/
			

//                	$error is a function of the form:
//                  function somename($errormessage)
//                  see the function displayError($msg) below for an example
//              example:
//                  retreiveStatus('myDisplayFunc', 'myErrorFunc');
//              you do _not_ need to edit anything in this script
// history    : 1.0.0
//     			- I have take El Muertes UT2003 Query script as a base to modify it to XMPs needs
//				  Specs and original Script @ http://unreal.student.utwente.nl
///////////////////////////////////////////////////////////////////////////////

/*

    XMP Server PHP status query
   
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

$CONFIG["games"] = array("XMP");
$CONFIG["queryport"]["XMP"] = 1;
$CONFIG["sockbuff"] = 8192;
$CONFIG["serverdata"] = array("servername", "mapname", "gametype");
$CONFIG["datanames"] = array("servermode", "adminname", "adminemail", "mutator", "serverversion", "teamdamage", "respawntime", "balanceteams", "prematchwait", "friendlyfire", "vehiclemode", "autobalance", "gamestats");

function array_csort() {  //coded by Ichier2003
   $args = func_get_args();
   $marray = array_shift($args);

   $msortline = "return(array_multisort(";
   foreach ($args as $arg) {
       $i++;
       if (is_string($arg)) {
           foreach ($marray as $row) {
               $sortarr[$i][] = $row[$arg];
           }
       } else {
           $sortarr[$i] = $arg;
       }
       $msortline .= "\$sortarr[".$i."],";
   }
   $msortline .= "\$marray));";

   eval($msortline);
   return $marray;
}
function hexview($data){
  $bytePosition = $columnCount = $lineCount = 0;
  $columns = 16;
  $dataLength = strlen($data);
  $return = array();
  $return[] = '<table border="1" cellspacing="0" cellpadding="2">';
  for($n = 0; $n < $dataLength; $n++){
   $lines[$lineCount][$columnCount++] = substr($data, $n, 1);
   if($columnCount == $columns){
     $lineCount++;
     $columnCount = 0;
   }
  }
  foreach($lines as $line){
   $return[] = '<tr><td align="right">'.$bytePosition.': </td>';
   for($n = 0; $n < $columns; $n++){
     $return[] = '<td>'.strtoupper(bin2hex($line[$n])).'</td>';
   }
   $return[] = '<td> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </td>';
   for($n = 0; $n < $columns; $n++){
     $return[] = '<td>'.(htmlentities($line[$n]) ? htmlentities($line[$n]) : '&nbsp;').'</td>';
   }
   $return[] = '</tr>';
   $bytePosition = $bytePosition + $columns;
  }
  $return[] = '</table>';
  return implode('', $return);
}

// print debug output
function debug($line)
{
  global $HTTP_VARS;
  if ($HTTP_VARS["debug"] == "1") echo $line."\n";
  flush();
}

// convert a boolean result to a better readable value
function boolToString($bool)
{
  $bool = strtolower($bool);
  switch ($bool)
  {
    case "true"  : return "Yes";
    case "false"  : return "No";
    case "1"  : return "Yes";
    case "0"  : return "No";
  }
}



function bin2signedint($bin, $len=4)
{
  $tmp = hexdec(bin2hex($bin));
  return sprintf("%d", $tmp);
}

function bin2int($bin)
{
  return hexdec(bin2hex($bin));
}

function colorize_it($bincode, $stepping){
	
	global $colors; 
	
	$font_tag_open=false;

	$i=0;
	
	switch ($stepping){
		case "2":
			while ($i < strlen($bincode)){
		
				if (bin2hex( substr($bincode,$i,$stepping*2)) == "5e002300" ){ 	
				
					$i += 4; // Skip the next 2 bytes
				}
		
				if ( $bincode[$i+1] == chr(1)){
					// Alert: After the sequence "5e002300" may be more than one sequence like "xx 01" 
					// I take the last color information "xx" for color coding 
		
					$colorcode_binary=bin2int($bincode[$i]);
					$i += 2;
			
					$colorcode_binary++; 
				
					$colorcode_html=$colors[$colorcode_binary];
				
					$name.="<font color=$colorcode_html>";
			
					$font_tag_open=true;

				} else {

					$name.=htmlspecialchars($bincode[$i]);
					$i++;
					if ($bincode[$i] == chr(0)) $i++;
					if ($bincode[$i] == chr(0)) $i++;
					if ($bincode[$i] == chr(0)) $i++;
				}
			
			}
		break;
		case "1":
			$color_ident_string = "5e23";
			while ($i < strlen($bincode)){
		
				if (bin2hex( substr($bincode,$i,$stepping*2)) == "5e23" ){ 
				
					$i += 2; // Skip the next 2 bytes
						
					// Alert: After the sequence "5e002300" may be more than one sequence like "xx 01" 
					// I take the last color information "xx" for color coding 
					
					$colorcode_binary=bin2int($bincode[$i]);
					$i ++;
			
					$colorcode_binary++; 
				
					$colorcode_html=$colors[$colorcode_binary];
				
					$name.="<font color=$colorcode_html>";
			
					$font_tag_open=true;

				} else {

					$name.=htmlspecialchars($bincode[$i]);
					$i++;
					if ($bincode[$i] == chr(0)) $i++;
				}
			}
		
		break;
	}
	
	if ($font_tag_open){
		$name.="</font>";	
	}
	
	return $name;
}

function uncolorize_it($bincode, $stepping){ // Strips off color information of a binary string
	
	$i=0;
	
	switch ($stepping){
		case "2":
			while ($i < strlen($bincode)){
				if (bin2hex( substr($bincode,$i,$stepping*2)) == "5e002300" ){ 	// Kennzeichnet einen Farb-Tag
					$i += 4; // berspringe die n Bytes
				}
				if ( $bincode[$i+1] == chr(1)){
					// Alert: After the sequence "5e002300" may be more than one sequence like "xx 01" 
					// I take the last color information "xx" for color coding 
					$i += 2;
				} else {
					$name.=htmlspecialchars($bincode[$i]);
					$i++;
					if ($bincode[$i] == chr(0)) $i++;
					if ($bincode[$i] == chr(0)) $i++;
					if ($bincode[$i] == chr(0)) $i++;
				}
			}
		break;
		case "1":
			$color_ident_string = "5e23";
			while ($i < strlen($bincode)){
			if (bin2hex( substr($bincode,$i,$stepping*2)) == "5e23" ){ 	// Kennzeichnet einen Farb-Tag
				$i += 2; // skip n bytes
					// Alert: After the sequence "5e002300" may be more than one sequence like "xx 01" 
					// I take the last color information "xx" for color coding 
					$i ++;
				} else {
					$name.=htmlspecialchars($bincode[$i]);
					$i++;
					if ($bincode[$i] == chr(0)) $i++;
				}
			}
		break;
	}
	return $name;
}

// function to display the results
function display_Info($info){
  global $CONFIG, $HTTP_VARS;

  echo "\n<table columns=\"2\">";
  
  if ($info["servername"]) echo "\n<tr><td>Server name</td><td>".colorize_it($info["servername"],1)."</td></tr>";
  if ($info["adminname"]) echo "\n<tr><td>Admin name</td><td>".colorize_it($info["adminname"],1)."</td></tr>";
  if ($info["adminemail"]) echo "\n<tr><td>Admin email</td><td>".colorize_it($info["adminemail"],1)."</td></tr>";
  if ($info["mutator"]) echo "\n<tr><td>Mutators</td><td>".htmlspecialchars($info["mutator"])."</td></tr>";
  if ($info["gameport"]) echo "\n<tr><td>Location</td><td>".$HTTP_VARS["ip"].":".$info["gameport"]."</td></tr>";
  if ($info["serverversion"]) echo "\n<tr><td>Server Version</td><td>".$info["serverversion"]."</td></tr>";
  if ($info["servermode"]) echo "\n<tr><td>Server Mode</td><td>".$info["servermode"]."</td></tr>";
  if ($info["autobalance"]) echo "\n<tr><td>Autobalance</td><td>".boolToString($info["autobalance"])."</td></tr>";
  if ($info["gamestats"]) echo "\n<tr><td>Stats enabled</td><td>".boolToString($info["gamestats"])."</td></tr>";
  if ($info["mapname"]) echo "\n<tr><td>Map</td><td>".htmlspecialchars($info["mapname"])."</td></tr>";
  if ($info["numplayers"]) echo "\n<tr><td>Players</td><td>".$info["numplayers"]."</td></tr>";
  if ($info["maxplayers"]) echo "\n<tr><td>Max. players</td><td>".$info["maxplayers"]."</td></tr>";
  if ($info["teamdamage"]) echo "\n<tr><td>Team Damage</td><td>".$info["teamdamage"]."</td></tr>";
  if ($info["respawntime"]) echo "\n<tr><td>Respawntime</td><td>".$info["respawntime"]."</td></tr>";
  if ($info["prematchwait"]) echo "\n<tr><td>Prematch Wait</td><td>".$info["prematchwait"]."</td></tr>";
 
 
  echo "\n</table>";
  $CONFIG["datanames"] = array("servermode", "adminname", "adminemail", "mutator", 
"serverversion", "teamdamage", "respawntime", "autobalance", "prematchwait", "friendlyfire", 
"vehiclemode", "autobalance", "gamestats", "servermode");

  $i_red=0;
  $i_blue=0;
  for ($i = 0; $i < intval($info["numplayers"]); $i++)
  {
    if ($info["player_".$i]){
    	
    	$team = uncolorize_it($info["player ".$i." info_val 1"], 2);
      	
    	switch ($team){
    	
    		case "red":
    		    $players_red[$i_red]['name']=$info["player_".$i]; 
				$players_red[$i_red]['score'] =$info["score_".$i];
				$players_red[$i_red]['ping'] =$info["ping_".$i]; 
				$players_red[$i_red]['team']=colorize_it($info["player ".$i." info_val 1"], 2);
				$players_red[$i_red]['class'] =$info["player ".$i." info_val 2"];
				$players_red[$i_red]['artifact'] =$info["player ".$i." info_val 3"];
				$i_red++;
    		break;
    		case "blue":
    			$players_blue[$i_blue]['name']=$info["player_".$i]; 
				$players_blue[$i_blue]['score'] =$info["score_".$i];
				$players_blue[$i_blue]['ping'] =$info["ping_".$i];
				$players_blue[$i_blue]['team'] =colorize_it($info["player ".$i." info_val 1"], 2);
				$players_blue[$i_blue]['class'] =$info["player ".$i." info_val 2"];
				$players_blue[$i_blue]['artifact'] =$info["player ".$i." info_val 3"];
				$i_blue++;
    		break;	
    	}    
    }
  }
	if ($players_blue) $players_blue = array_csort($players_blue, 'score',SORT_DESC, 'artifact');
	if ($players_red) $players_red = array_csort($players_red, 'score',SORT_DESC, 'artifact');
	
	// player info
  echo "\n<table>";
  echo "\n<tr><td>";
  echo "<table>";
  echo "\n <tr><td colspan=5><font color=#FF0000>TEAM RED </font></td></tr>";
  echo "\n <tr><td>name</td><td>score</td><td>ping</td><td>Class</td><td>Artifact</td></tr>";
  
  for ($y=0; $y < count($players_red); $y++) {
		
       	echo "<tr><td>" . $players_red[$y]['name'] . "</td>";
		echo "<td>".$players_red[$y]['score']."</td>";
		echo" <td>".$players_red[$y]['ping']."</td>";
		#echo" <td>".uncolorize_it($info["player ".$i." info_val 1"], 2)."</td>"; // Team
		echo" <td>".$players_red[$y]['class']."</td>";	// Class
		echo "<td>".$players_red[$y]['artifact']."</td>"; // Arti
	
		echo "\n</tr>";
	}
  echo "\n</table></td><td>";
  
  echo "<table>";
  echo "\n <tr><td colspan=5><font color=#0000FF>TEAM BLUE </font></td></tr>";
  echo "\n <tr><td>name</td><td>score</td><td>ping</td><td>Class</td><td>Artifact</td></tr>";
  for ($y=0; $y < count($players_blue); $y++) {
		echo "<tr><td>" . $players_blue[$y]['name'] . "</td>";
		echo "<td>".$players_blue[$y]['score']."</td>";
		echo" <td>".$players_blue[$y]['ping']."</td>";
		#echo" <td>".uncolorize_it($info["player ".$i." info_val 1"], 2)."</td>"; 
		echo" <td>".$players_blue[$y]['class']."</td>";	// Class
		echo "<td>".$players_blue[$y]['artifact']."</td>"; // Arti
		echo "\n</tr>";
	}
  echo "\n</table>";
  

    echo "\n</td></tr>";
	echo "\n</table>";

}

// example dunction to display an error message
function displayError($msg)
{
  echo "<b>Error:</b><br />".$msg;
}



// parse the binairy data received from the server
function parseInfo2($data, $displayfunction, $errorfunction)
{
  global $CONFIG, $HTTP_VARS;
  $playerinfo = false;
  $data = explode('\n', str_replace(pack("Cxxx", ord($data[0])), '\n', $data));
  array_shift($data);
  
 
  for ($n = 0; $n < count($data); $n++)
  {
    if ($data[$n][0] == chr(0))
    {
      debug("Server info");
      if ($HTTP_VARS["debug"] == "1") echo hexview($data[$n]);
      $strlen = strlen($data[$n]);
      $i = 0;
      while (($data[$n][$i] == chr(0)) && ($i < $strlen)) $i++;
      $info["gameport"] = bin2int($data[$n][$i+1].$data[$n][$i]);
      $i += 2;
      for ($j = 0; $j < 3; $j++)
      {
        while (($data[$n][$i] == chr(0)) && ($i < $strlen)) $i++;
        $i++;
        while (($data[$n][$i] != chr(0)) && ($i < $strlen))
        {
          $info[$CONFIG["serverdata"][$j]] .= $data[$n][$i];
          $i++;
        }
      }
      $i++;
      $info["numplayers"] = bin2int($data[$n][$i+3].$data[$n][i+2].$data[$n][$i+1].$data[$n][$i]);
      $i += 4;
      $info["maxplayers"] = bin2int($data[$n][$i+3].$data[$n][$i+2].$data[$n][$i+1].$data[$n][$i]);
    }
    else if ($data[$n][0] == chr(1))
    {
      debug("\nGame info");
      if ($HTTP_VARS["debug"] == "1") echo hexview($data[$n]);
      $strlen = strlen($data[$n]);
      for ($i = 1; $i < $strlen; $i++)
      {
        $str = "";
        $vallen = bin2int($data[$n][$i]);
        $i++; // string len
        if ($vallen != 0)
        {
          for ($j = 0; $j < $vallen-1; $j++)
          {
            $str .= $data[$n][$i];
            $i++;
          }
          $tmpinfo[] = $str;
        }
        else {
          $i--; // no string go one back
          $tmpinfo[] = "";
        }
      }
      for ($i = 0; $i < count($tmpinfo); $i++)
      {
        if ($tmpinfo[$i] != "")
        {
          $tname = strtolower($tmpinfo[$i]);
          #echo "\n Serverdaten $i:  $tmpinfo[$i]";
          if (in_array($tname, $CONFIG["datanames"]))
          {
            if ($info[$tname] != "") $info[$tname] .= ",";
            $info[$tname] .= $tmpinfo[$i+1];
            $i++;
          }
          else {
            debug("Unknown data:".$tmpinfo[$i]);
          }
        }
      }
    }
    else if ($data[$n][0] == chr(2)){
     
      debug("Player info\n");
      $i = 0;

 	  while ($data[$n]){
 	  		$playerdata.=substr($data[$n],9);
 	  		$n++;
 	  }
	 
	  if ($HTTP_VARS["debug"] == "1") echo hexview($playerdata);
     
      $strlen = strlen($playerdata);
     
      for ($j = 0; $j < $info["numplayers"]; $j++){


		$namensstring=$playerdata[$i];
		$i++;
      
        if (bin2int($namensstring)>128){
        
        	$Laenge_Name=2*(bin2int($namensstring)-128);
        	$stepping=2;
        } else {
        	$Laenge_Name=bin2int($namensstring);
        	$stepping=1;
        }
                
        $temp=$i;
    
        while ($i<$Laenge_Name+$temp){
			$info["player_".$j] .= $playerdata[$i];
 			$i++;
        }
   
		if ($HTTP_VARS['monochrome']==1){ 
			$info["player_".$j] = uncolorize_it($info["player_".$j], $stepping);  //Only here we do have knowledge of the stepping. So we have to do the colorization here....
		} else {
			$info["player_".$j] = colorize_it($info["player_".$j], $stepping); 
		}

        $info["ping_".$j] = bin2signedint($playerdata[$i+3].$playerdata[$i+2].$playerdata[$i+1].$playerdata[$i]);
       
        $i += 4;
        $info["score_".$j] = bin2signedint($playerdata[$i+3].$playerdata[$i+2].$playerdata[$i+1].$playerdata[$i]);

        $i += 4;
        
        $i += 4;
        $info["props_".$j] = bin2signedint($playerdata[$i]);
       
        $len_props=$info["props_".$j]; // Length
        $i ++;

        for ($x = 1; $x<= $len_props; $x++){
            $str = "";
            $vallen = bin2int($playerdata[$i]);
 
            $i++; // string len
          
            for ($jq = 0; $jq < $vallen-1; $jq++){
                $str .= $playerdata[$i];
                $i++;
            }
            $info["player $j info_key $x"] = $str;
           
           	$i++;
            $vallen = ($playerdata[$i]);
            
         	 if (bin2int($vallen )>128){
        
        		$vallen =2*(bin2int($vallen )-128);
        		$stepping=2;
       		} else {
        		$vallen =bin2int($vallen) ;
        		$stepping=1;
        	}

            $str="";
            $i++; // string len
           
            for ($jq = 0; $jq < $vallen-1; $jq++){
                $str .= $playerdata[$i];
                $i++;
            }      
            
            $info["player $j info_val $x"] = $str;

		    $i++;
      	}
       	while (($playerdata[$i] == chr(0)) && ($i < $strlen)) $i++;
      }
    }
  }
  
  if (count($info)) 
  {
    if ($displayfunction) $displayfunction($info);
  }
  else {
    debug("No data received");
    $errorfunction("No valid information received");
  }
  
  return $info;
}

// query the UT server
function retreiveStatus($displayfunction = 'display_Info', $errorfunction = 'displayError')
{
  global $HTTP_VARS, $CONFIG;
  
  debug("<pre>");
 
  if ($HTTP_VARS["game"] == "") $HTTP_VARS["game"] = "XMP";
  if ($HTTP_VARS["gp"] == "") $HTTP_VARS["gp"] = "7777";
  $HTTP_VARS["qp"] = $HTTP_VARS["gp"]+$CONFIG["queryport"][$HTTP_VARS["game"]];
  debug("Target = ".$HTTP_VARS["ip"].":".$HTTP_VARS["gp"]);
  debug("Query port = ".$HTTP_VARS["qp"]);

  if ($HTTP_VARS["ip"])
  {
    $sock = fsockopen("udp://".$HTTP_VARS["ip"], $HTTP_VARS["qp"]);
    if ($sock === false)
    {
      debug("Unknown host");
      $errorfunction("Unknown host.");
    }
    else 
    {
      socket_set_timeout($sock, 1, 0);
      fwrite($sock, pack("Cxxxx", 0x7e));
      fwrite($sock, pack("CxxxC", 0x7e, 0x01));
      fwrite($sock, pack("CxxxC", 0x7e, 0x02));

      $x=true;
      while ($x){
      	$line = @fread($sock, $CONFIG["sockbuff"]);
      	$result .= $line;
      	if ($line =="") $x=false;
      }

      if (strlen($result) != 0){
        parseInfo2($result, $displayfunction, $errorfunction); 
      } 
      else {
      	
        debug("No server running");
        $errorfunction("No server found");
      }
      fclose($sock);
    } 
  }
  else {
    debug("No host provided");
    $errorfunction("No hostname provided");
  }
}

?>